function [DW] = durbinwatson(X)

% durbinwatson  Calculates the Durbin-Watson statistic for a vector of regression errors
%
%           Usage: residuals = durbinwatson(X)

% Author : Brian Kirtlan, Electricity Commission, 27/5/04

% Check inputs

[n, colX] = size(X);

if colX ~= 1, 
    error('X must be a vector'); 
end

% Durbin Watson Statistic

DW = (sum((X(2:n)-X(1:n-1)).^2))/sum(X.^2);